const db = require('../db');

const Message = {

    async getByConversation(sender_id, receiver_id) {
        const [rows] = await db.query(
            `SELECT 
                id,
                message_sid,
                sender_id,
                receiver_id,
                body,
                date_sent,
                created_at,
                sent,
                failed,
                unread
            FROM messages
            WHERE 
                (sender_id = ? AND receiver_id = ?)
                OR
                (sender_id = ? AND receiver_id = ?)
            ORDER BY created_at ASC`,
            [sender_id, receiver_id, receiver_id, sender_id]
        );
        return rows;
    },

    async create(data) {

        const {
            message_sid = null,
            sender_id,
            receiver_id,
            body,
            date_sent = null,
            sent = 1,
            failed = 0,
            unread = 0
        } = data;

        const [result] = await db.query(
            `INSERT INTO messages 
            (message_sid, sender_id, receiver_id, body, date_sent, created_at, sent, failed, unread) 
             VALUES (?, ?, ?, ?, ?, NOW(), ?, ?, ?)`,
            [
                message_sid,
                sender_id,
                receiver_id,
                body,
                date_sent,   // <-- this can be null or timestamp
                sent,
                failed,
                unread
            ]
        );

        // Return full message object
        const [rows] = await db.query('SELECT * FROM messages WHERE id = ?', [result.insertId]);
        return rows[0];
    }
};

module.exports = Message;
